package unipotsdam.informatikkiste;

import java.util.LinkedList;
import java.util.regex.Pattern;

/**
 * Represents an Answer to a Riddle
 * Created by Robin Engel on 23.06.2017.
 */

public class RiddleAnswer {

    private int riddleId;
    private String answerRegEx;

    private LinkedList<AnswerEvent> events;

    /**
     * Creates a new RiddleAnswer
     * @param riddleId the id of the Riddle the Answer is referring to
     * @param answerRegEx an Regular Expression representing the text, which activates the answer
     */
    public RiddleAnswer(int riddleId, String answerRegEx){
        this.riddleId = riddleId;
        this.answerRegEx = answerRegEx;

        this.events = new LinkedList<AnswerEvent>();
    }

    /** Adds a new AnswerEvent to the RiddleAnswer
     * @param event the event to be added
     */
    public void addAnswerEvent(AnswerEvent event){
        this.events.add(event);
    }

    /**
     * @param riddleId
     * @param answer
     * @return the {@link LinkedList} of {@link AnswerEvent}s or null if the RiddleAnswer is not
     * activated by the given parameters
     */
    public LinkedList<AnswerEvent> getEventsIfActivated(int riddleId, String answer){
        if(riddleId != this.riddleId){//wrong Riddle
            return null;
        }
        if(Pattern.matches(this.answerRegEx,answer)){
            return this.events;
        }
        else{
            return null; //answer not triggered
        }
    }
}
